/*
 * Decompiled with CFR 0.152.
 */
package main;

import audio.AudioPlayer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import main.Target;
import main.TargetDisappear;
import main.mouseListen;

public class Game
extends JPanel
implements Runnable {
    private static final long serialVersionUID = -7600755214008009002L;
    public static final int WIDTH = 300;
    public static final int HEIGHT = 225;
    public static final int SCALE = 3;
    public static final int FPS = 30;
    public static final int TIMERSCALE = 700;
    public static final int LEVELHITLIMIT = 10;
    public static final int LEVELMAX = 15;
    private Vector<Target> vT;
    private Vector<TargetDisappear> vTD;
    private Random rand;
    private int hitCounter = 0;
    private int gScore = 0;
    private int level = 1;
    private int gX;
    private int gY;
    private long createTime = 0L;
    private long levelInit = 0L;
    private int levelInitDelay = 5000;
    private long levelTimer = 0L;
    private long levelTimeLimit = 45000L;
    private int timeLeft = (int)(this.levelTimeLimit / 1000L);
    private int timerClosingCounter = 0;
    private String logo = "eNDgamers Production";
    private boolean running = false;
    private boolean bIntro = false;
    private boolean timeOver = false;
    private boolean timeLimitClosing = false;
    private static boolean wait = true;
    private JFrame frame = new JFrame("Game");
    private BufferedImage image;
    private BufferedImage cImage;
    private Graphics2D g;
    public mouseListen mListen;
    public AudioPlayer apIntro;
    private Thread thread = new Thread((Runnable)this, "Game Runner");
    private Insets insets;

    public Game() {
        this.rand = new Random();
        this.mListen = new mouseListen();
        this.vT = new Vector(5, 5);
        this.vTD = new Vector(5, 5);
        wait = true;
    }

    public synchronized void start() {
        this.bIntro = true;
        this.running = true;
        if (this.insets == null) {
            this.insets = this.frame.getInsets();
            this.image = new BufferedImage(900 + this.insets.left * 2 + this.insets.right * 2, 675 + this.insets.top * 2 + this.insets.bottom * 2, 1);
            this.g = (Graphics2D)this.image.getGraphics();
            this.g.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            this.g.fillRect(0, 0, 900 + this.insets.left * 2 + this.insets.right * 2, 675 + this.insets.top * 2 + this.insets.bottom * 2);
            try {
                this.cImage = ImageIO.read(this.getClass().getResourceAsStream("/image/crosshair.png"));
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            this.g.drawImage((Image)this.cImage, this.mListen.getMMX() - 25, this.mListen.getMMY() - 25, null);
        }
        this.mListen.setInsets(this.insets);
        this.apIntro = new AudioPlayer("/audio/Intro.wav");
        this.apIntro.playContinuous();
        this.thread.start();
    }

    public void intro() {
        this.g.setColor(new Color(240, 240, 240));
        this.g.fillRect(this.insets.left, this.insets.top, this.getWidth() - this.insets.right, this.getHeight() / 6);
        this.g.setStroke(new BasicStroke(3.0f));
        this.g.setColor(new Color(240, 240, 240).darker());
        this.g.drawRect(this.insets.left, this.insets.top, this.getWidth() - this.insets.right, this.getHeight() / 6 - this.insets.bottom);
        this.g.setStroke(new BasicStroke(1.0f));
        this.g.setColor(new Color(87, 115, 229));
        this.g.fillRect(this.insets.left, this.insets.top + this.getHeight() / 6, this.getWidth(), 5 * this.getHeight() / 6 + this.insets.bottom);
        this.g.setStroke(new BasicStroke(3.0f));
        this.g.setColor(new Color(87, 115, 229).darker());
        this.g.drawRect(this.insets.left, this.insets.top + this.getHeight() / 6, this.getWidth() - this.insets.right, 5 * this.getHeight() / 6 - this.insets.bottom);
        this.g.setStroke(new BasicStroke(1.0f));
        String[] str1 = new String[]{"TA", "RG", "ET"};
        String[] str2 = new String[]{"CENTER RED : 10 Points", "WHITE      :  5 Points", "OUTER RED  :  1 Points", "Hit 10 targets in 45 Seconds", "To advance to next level", "Click to continue...."};
        this.g.setFont(new Font("Century Gothic", 1, 72));
        this.g.setColor(Color.RED);
        int length = (int)this.g.getFontMetrics().getStringBounds(str1[0], this.g).getWidth();
        this.g.drawString(str1[0], (this.getWidth() - length * 3) / 2, this.insets.top + 72);
        this.g.setColor(Color.GRAY);
        this.g.drawString(str1[1], (this.getWidth() - length) / 2, this.insets.top + 72);
        this.g.setColor(Color.RED);
        this.g.drawString(str1[2], (this.getWidth() + length) / 2 + 15, this.insets.top + 72);
        this.g.setFont(new Font("Century Gothic", 0, 36));
        this.g.setColor(Color.RED);
        this.g.drawString(str2[0], this.insets.left + 30, this.getHeight() / 4 + 60);
        this.g.setColor(Color.WHITE);
        this.g.drawString(str2[1], this.insets.left + 30, this.getHeight() / 4 + 120);
        this.g.setColor(Color.RED);
        this.g.drawString(str2[2], this.insets.left + 30, this.getHeight() / 4 + 180);
        this.g.setColor(Color.BLACK);
        length = (int)this.g.getFontMetrics().getStringBounds(str2[3], this.g).getWidth();
        this.g.drawString(str2[3], (this.getWidth() - length) / 2, this.getHeight() / 4 + 300);
        length = (int)this.g.getFontMetrics().getStringBounds(str2[4], this.g).getWidth();
        this.g.drawString(str2[4], (this.getWidth() - length) / 2, this.getHeight() / 4 + 360);
        length = (int)this.g.getFontMetrics().getStringBounds(str2[5], this.g).getWidth();
        this.g.drawString(str2[5], (this.getWidth() - length) / 2, this.getHeight() - 36);
        this.g.setFont(new Font("Century Gothic", 1, 15));
        length = (int)this.g.getFontMetrics().getStringBounds(this.logo, this.g).getWidth();
        this.g.drawString(this.logo, this.getWidth() - length - this.insets.right - 6, this.getHeight() / 6 + this.insets.top - 15);
        new Target(this.getWidth() - 180, this.getHeight() / 4 + 90, 1, System.currentTimeMillis()).render(this.g);
        this.g.drawImage((Image)this.cImage, this.mListen.getMMX() - 25, this.mListen.getMMY() - 25, null);
        if (this.mListen.isClicked()) {
            this.bIntro = false;
            this.levelInit = System.currentTimeMillis();
        }
    }

    @Override
    public void run() {
        long lastTime = System.nanoTime();
        long timer = System.currentTimeMillis();
        double ns = 3.3333333333333332E7;
        double delta = 0.0;
        int fps = 0;
        int ups = 0;
        while (this.running) {
            long now = System.nanoTime();
            delta += (double)(now - lastTime) / 3.3333333333333332E7;
            lastTime = now;
            if (delta >= 1.0) {
                this.update();
                this.render();
                delta -= 1.0;
                ++ups;
            }
            this.gameDraw();
            ++fps;
            if (System.currentTimeMillis() - timer <= 1000L) continue;
            timer += 1000L;
            this.frame.setTitle("Game | UPS: " + ups + " FPS: " + fps);
            ups = 0;
            fps = 0;
        }
        this.apIntro.close();
        this.stop();
        System.out.println("Game Stopped");
    }

    public void update() {
        if (this.mListen.isEntered()) {
            this.frame.setCursor(this.frame.getToolkit().createCustomCursor(new BufferedImage(3, 3, 2), new Point(0, 0), "null"));
        }
        if (!this.bIntro) {
            if (System.currentTimeMillis() - this.levelInit < (long)this.levelInitDelay && wait) {
                int transp = (int)(Math.abs(Math.sin(Math.toRadians((System.currentTimeMillis() - this.levelInit) * 450L / (long)this.levelInitDelay))) * 255.0);
                if (transp > 255) {
                    transp = 255;
                }
                this.g.setColor(new Color(240, 240, 240));
                this.g.fillRect(this.insets.left, this.insets.top, this.getWidth() - this.insets.right, this.getHeight() / 6);
                this.g.setStroke(new BasicStroke(3.0f));
                this.g.setColor(new Color(240, 240, 240).darker());
                this.g.drawRect(this.insets.left, this.insets.top, this.getWidth() - this.insets.right, this.getHeight() / 6 - this.insets.bottom);
                this.g.setStroke(new BasicStroke(1.0f));
                this.g.setColor(new Color(87, 115, 229));
                this.g.fillRect(this.insets.left, this.insets.top + this.getHeight() / 6, this.getWidth(), 5 * this.getHeight() / 6 + this.insets.bottom);
                this.g.setStroke(new BasicStroke(3.0f));
                this.g.setColor(new Color(87, 115, 229).darker());
                this.g.drawRect(this.insets.left, this.insets.top + this.getHeight() / 6, this.getWidth() - this.insets.right, 5 * this.getHeight() / 6 - this.insets.bottom);
                this.g.setStroke(new BasicStroke(1.0f));
                this.g.setColor(new Color(255, 255, 255, transp));
                this.g.setFont(new Font("Centrury Gothic", 1, 36));
                String str = "- L E V E L " + this.level + " -";
                int length = (int)this.g.getFontMetrics().getStringBounds(str, this.g).getWidth();
                this.g.drawString(str, (this.getWidth() - length) / 2, this.getHeight() / 2);
                if (!this.vTD.isEmpty()) {
                    for (TargetDisappear tD : this.vTD) {
                        tD.render(this.g, this.gX, this.gY);
                    }
                }
                this.g.drawImage((Image)this.cImage, this.mListen.getMMX() - 25, this.mListen.getMMY() - 25, null);
            }
            if (System.currentTimeMillis() - this.levelInit > (long)this.levelInitDelay && wait) {
                wait = false;
            }
            if (!wait) {
                if (this.levelTimer == 0L) {
                    this.levelTimer = System.currentTimeMillis();
                }
                if (this.hitCounter >= 10 && this.level < 15) {
                    ++this.level;
                    this.hitCounter = 0;
                    this.levelInit = System.currentTimeMillis();
                    this.levelTimer = System.currentTimeMillis();
                    this.timerClosingCounter = 0;
                    this.timeLimitClosing = false;
                    wait = true;
                }
                if (System.currentTimeMillis() - this.levelTimer > this.levelTimeLimit) {
                    this.running = false;
                    this.timeOver = true;
                }
                this.timeLeft = (int)(this.levelTimeLimit - (System.currentTimeMillis() - this.levelTimer)) / 1000;
                if (this.timeLeft <= 11 && this.timeLeft > -1) {
                    ++this.timerClosingCounter;
                    this.timeLimitClosing = true;
                }
                if (this.timerClosingCounter % 30 == 0 && this.timeLimitClosing && this.timeLeft > 0) {
                    new AudioPlayer("/audio/Tick.wav").play();
                }
                if (this.timerClosingCounter % 30 == 0 && this.timeLimitClosing && this.timeLeft == 0) {
                    new AudioPlayer("/audio/Buzzer.wav").play();
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (InterruptedException e) {
                        System.out.println(e.getMessage());
                    }
                    this.timeLimitClosing = false;
                }
                if (this.level == 15) {
                    this.running = false;
                }
                if (this.running) {
                    if (this.createTime == 0L) {
                        this.createTime = System.currentTimeMillis();
                    }
                    System.out.println(3 * (700 - 43 * this.level));
                    if (System.currentTimeMillis() - this.createTime > (long)(3 * (700 - 43 * this.level))) {
                        this.createTime = 0L;
                        this.vT.add(new Target(this.rand.nextInt(this.getWidth() - this.insets.right - Target.getDia()) + this.insets.left + Target.getRad(), this.rand.nextInt(5 * this.getHeight() / 6 - this.insets.bottom - Target.getDia()) + this.insets.top + this.getHeight() / 6 + Target.getRad(), this.level, System.currentTimeMillis()));
                    }
                    if (this.mListen.isClicked()) {
                        this.gX = this.mListen.getMX();
                        this.gY = this.mListen.getMY();
                        if (!this.vT.isEmpty()) {
                            for (Target target : this.vT) {
                                this.gScore += target.getScore(this.gX, this.gY);
                                if (!target.isHit()) continue;
                                ++this.hitCounter;
                            }
                        }
                    }
                    if (!this.vT.isEmpty()) {
                        int i = 0;
                        while (i < this.vT.size()) {
                            boolean expire = false;
                            expire = this.vT.get(i).isExpire(System.currentTimeMillis());
                            if (expire) {
                                if (this.vT.get(i).isHit()) {
                                    this.vTD.add(new TargetDisappear(this.vT.get(i), this.level));
                                }
                                this.vT.remove(i);
                                --i;
                                break;
                            }
                            ++i;
                        }
                    }
                }
            }
        } else {
            this.intro();
        }
    }

    public void gameDraw() {
        this.g.setColor(new Color(240, 240, 240));
        this.g.fillRect(this.insets.left, this.insets.top, this.getWidth() - this.insets.right, this.getHeight() / 6);
        this.g.setStroke(new BasicStroke(3.0f));
        this.g.setColor(new Color(240, 240, 240).darker());
        this.g.drawRect(this.insets.left, this.insets.top, this.getWidth() - this.insets.right, this.getHeight() / 6 - this.insets.bottom);
        this.g.setStroke(new BasicStroke(1.0f));
        this.g.setColor(Color.BLACK);
        this.g.setFont(new Font("Century Gothic", 0, 21));
        this.g.drawString("SCORE: " + this.gScore, this.insets.left + 10, this.insets.top + 36);
        String str = "- L E V E L " + this.level + " -";
        int length = (int)this.g.getFontMetrics().getStringBounds(str, this.g).getWidth();
        this.g.drawString(str, (this.getWidth() - length) / 2, this.insets.top + 36);
        if (!this.timeLimitClosing || this.timeLeft > 10) {
            this.g.drawString("TIMER: 0:" + this.timeLeft, this.insets.left + 10, this.insets.top + 72);
        } else {
            int alpha = Math.abs((int)(Math.sin(180 * this.timerClosingCounter / 30) * 255.0));
            if (alpha > 255) {
                alpha = 255;
            }
            this.g.setColor(new Color(255, 0, 0, alpha));
            if (this.timeLeft < 10) {
                this.g.drawString("TIMER: 0:0" + this.timeLeft, this.insets.left + 10, this.insets.top + 72);
            } else {
                this.g.drawString("TIMER: 0:" + this.timeLeft, this.insets.left + 10, this.insets.top + 72);
            }
        }
        this.g.setFont(new Font("Century Gothic", 1, 15));
        length = (int)this.g.getFontMetrics().getStringBounds(this.logo, this.g).getWidth();
        this.g.drawString(this.logo, this.getWidth() - length - this.insets.right - 6, this.getHeight() / 6 + this.insets.top - 15);
        this.g.setColor(new Color(87, 115, 229));
        this.g.fillRect(this.insets.left, this.insets.top + this.getHeight() / 6, this.getWidth(), 5 * this.getHeight() / 6 + this.insets.bottom);
        this.g.setStroke(new BasicStroke(3.0f));
        this.g.setColor(new Color(87, 115, 229).darker());
        this.g.drawRect(this.insets.left, this.insets.top + this.getHeight() / 6, this.getWidth() - this.insets.right, 5 * this.getHeight() / 6 - this.insets.bottom);
        this.g.setStroke(new BasicStroke(1.0f));
        if (!this.vT.isEmpty()) {
            for (Target target : this.vT) {
                target.render(this.g);
            }
        }
        if (!this.vTD.isEmpty()) {
            for (TargetDisappear tD : this.vTD) {
                tD.render(this.g, this.gX, this.gY);
            }
        }
        this.g.drawImage((Image)this.cImage, this.mListen.getMMX() - 25, this.mListen.getMMY() - 25, null);
    }

    public void render() {
        Graphics2D gFrame = (Graphics2D)this.frame.getGraphics();
        gFrame.drawImage((Image)this.image, 0, 0, null);
        gFrame.dispose();
    }

    public static boolean isWait() {
        return wait;
    }

    public void paintComponent(Graphics2D g) {
    }

    public synchronized void stop() {
        this.running = false;
        this.timeLimitClosing = false;
        this.g.setColor(new Color(240, 240, 240));
        this.g.fillRect(this.insets.left, this.insets.top, this.getWidth() - this.insets.right, this.getHeight() / 6);
        this.g.setStroke(new BasicStroke(3.0f));
        this.g.setColor(new Color(240, 240, 240).darker());
        this.g.drawRect(this.insets.left, this.insets.top, this.getWidth() - this.insets.right, this.getHeight() / 6 - this.insets.bottom);
        this.g.setStroke(new BasicStroke(1.0f));
        this.g.setColor(new Color(87, 115, 229));
        this.g.fillRect(this.insets.left, this.insets.top + this.getHeight() / 6, this.getWidth(), 5 * this.getHeight() / 6);
        this.g.setStroke(new BasicStroke(3.0f));
        this.g.setColor(new Color(87, 115, 229).darker());
        this.g.drawRect(this.insets.left, this.insets.top + this.getHeight() / 6, this.getWidth() - this.insets.right, 5 * this.getHeight() / 6 - this.insets.bottom);
        this.g.setStroke(new BasicStroke(1.0f));
        this.g.setColor(Color.WHITE);
        this.g.setFont(new Font("Century Gothic", 0, 36));
        String str1 = "- GAME OVER -";
        String str2 = "FINAL SCORE: " + this.gScore;
        int length1 = (int)this.g.getFontMetrics().getStringBounds(str1, this.g).getWidth();
        int length2 = (int)this.g.getFontMetrics().getStringBounds(str2, this.g).getWidth();
        this.g.drawString(str1, (this.getWidth() - length1) / 2, this.getHeight() / 2);
        this.g.drawString(str2, (this.getWidth() - length2) / 2, this.getHeight() / 2 + 72);
        if (this.timeOver) {
            new AudioPlayer("/audio/Fail.wav").play();
            this.g.setColor(Color.RED);
            String str3 = "TIMER RAN OUT!!!!";
            int length3 = (int)this.g.getFontMetrics().getStringBounds(str3, this.g).getWidth();
            this.g.drawString(str3, (this.getWidth() - length3) / 2, this.getHeight() / 2 - 72);
        }
        this.render();
        try {
            System.out.println("Game starting to close");
            this.thread.join(2000L);
        }
        catch (InterruptedException e) {
            System.out.println(e.getMessage());
        }
    }

    public static void main(String[] args) {
        Game game = new Game();
        game.frame.add(game);
        game.frame.setVisible(true);
        game.setPreferredSize(new Dimension(900, 675));
        game.frame.createBufferStrategy(3);
        game.frame.pack();
        game.frame.setResizable(false);
        game.frame.setFocusable(true);
        game.frame.requestFocus();
        game.frame.setDefaultCloseOperation(3);
        game.frame.addMouseMotionListener(game.mListen);
        game.frame.addMouseListener(game.mListen);
        game.start();
    }
}

